<?php 

include "includes/config.php"; 
$pageTitle = "Home";
$pageDescription = "Welcome to " . SITE_NAME . " - Your trusted partner for professional services.";
include 'includes/header.php'; 
?>

    <section class="hero">
        <div class="hero-content">
            <h1>Professional Business Solutions</h1>
            <p>We provide top-quality services tailored to your specific needs.</p>
            <div class="hero-buttons">
                <a href="services.php" class="btn btn-primary">Our Services</a>
                <a href="contact.php" class="btn btn-secondary">Contact Us</a>
            </div>
        </div>
    </section>
    
    <section class="features">
        <div class="section-header">
            <h2>Why Choose Us</h2>
            <p>We stand out from the competition</p>
        </div>
        
        <div class="features-grid">
            <div class="feature-item">
                <i class="fas fa-star"></i>
                <h3>Quality Service</h3>
                <p>We deliver exceptional quality in all our services.</p>
            </div>
            
            <div class="feature-item">
                <i class="fas fa-users"></i>
                <h3>Client Focused</h3>
                <p>Your satisfaction is our top priority.</p>
            </div>
            
            <div class="feature-item">
                <i class="fas fa-clock"></i>
                <h3>Timely Delivery</h3>
                <p>We respect your time and meet all deadlines.</p>
            </div>
            
            <div class="feature-item">
                <i class="fas fa-certificate"></i>
                <h3>Professionalism</h3>
                <p>Our experts have years of industry experience.</p>
            </div>
        </div>
    </section>
    
    <section class="about-preview">
        <div class="about-content">
            <h2>About Our Company</h2>
            <p>Founded in 20XX, we have been providing exceptional services to clients across various industries. Our mission is to deliver value and build long-term relationships with our clients.</p>
            <a href="about.php" class="btn btn-primary">Learn More</a>
        </div>
        <div class="about-image">
            <img src="assets/images/about-preview.jpg" alt="Our Team">
        </div>
    </section>
    
    <section class="testimonials">
        <div class="section-header">
            <h2>What Our Clients Say</h2>
            <p>Hear from our satisfied customers</p>
        </div>
        
        <div class="testimonial-slider">
            <div class="testimonial-item">
                <div class="testimonial-content">
                    <p>"Excellent service! The team went above and beyond to meet our requirements."</p>
                </div>
                <div class="testimonial-author">
                    <h4>Demola</h4>
                    <span>CEO, Photo-One</span>
                </div>
            </div>
            
            <div class="testimonial-item">
                <div class="testimonial-content">
                    <p>"Professional and reliable. We've been working with them for years and always impressed."</p>
                </div>
                <div class="testimonial-author">
                    <h4>Hussain K.</h4>
                    <span>Director, Global Tech.</span>
                </div>
            </div>
        </div>
    </section>

<?php include 'includes/footer.php'; ?>